

/** \file     TDecCAVLC.h
    \brief    CAVLC decoder class (header)
*/

#ifndef __TDECCAVLC__
#define __TDECCAVLC__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TDecEntropy.h"

// ====================================================================================================================
// Class definition
// ====================================================================================================================

class SEImessages;

/// CAVLC decoder class
class TDecCavlc : public TDecEntropyIf
{
public:
  TDecCavlc();
  virtual ~TDecCavlc();
  
protected:
  Void  xReadCode             (UInt uiLength, UInt& ruiCode);
  Void  xReadUvlc             (UInt& ruiVal);
  Void  xReadSvlc             (Int& riVal);
  Void  xReadFlag             (UInt& ruiCode);
  Void  xReadEpExGolomb     ( UInt& ruiSymbol, UInt uiCount );
  Void  xReadExGolombLevel  ( UInt& ruiSymbol );
  Void  xReadUnaryMaxSymbol ( UInt& ruiSymbol, UInt uiMaxSymbol );
  
  UInt  xGetBit             ();
  Int   xReadVlc            ( Int n );
#if CAVLC_COEF_LRG_BLK
  Void  xParseCoeff         ( TCoeff* scoeff, Int iTableNumber, Int blSize);
#else
  Void  xParseCoeff4x4      ( TCoeff* scoeff, Int iTableNumber );
  Void  xParseCoeff8x8      ( TCoeff* scoeff, Int iTableNumber );
#endif
#if QC_MOD_LCEC
  Void  xRunLevelIndInv     (LastCoeffStruct *combo, Int maxrun, UInt lrg1Pos, UInt cn);
#if RUNLEVEL_TABLE_CUT
  Void  xRunLevelIndInterInv(LastCoeffStruct *combo, Int maxrun, UInt cn);
#endif
#endif
  
private:
  TComBitstream*        m_pcBitstream;
  UInt                  m_uiCoeffCost;
  Bool                  m_bRunLengthCoding;
  UInt                  m_uiRun;
  Bool m_bAlfCtrl;
  UInt m_uiMaxAlfCtrlDepth;
  UInt                      m_uiLPTableD4[3][32];
#if !CAVLC_COEF_LRG_BLK
  UInt                      m_uiLPTableD8[10][128];
#endif
  UInt                      m_uiLastPosVlcIndex[10];
  
#if LCEC_INTRA_MODE
#if MTK_DCM_MPM
  UInt                      m_uiIntraModeTableD17[2][16];
  UInt                      m_uiIntraModeTableD34[2][33];
#else
  UInt                      m_uiIntraModeTableD17[16];
  UInt                      m_uiIntraModeTableD34[33];
#endif
#endif
#if QC_LCEC_INTER_MODE
  UInt                      m_uiSplitTableD[4][7];
#endif
#if CAVLC_RQT_CBP
  UInt                      m_uiCBP_YUV_TableD[4][8];
  UInt                      m_uiCBP_YS_TableD[2][4];
  UInt                      m_uiCBP_YCS_TableD[2][8];
  UInt                      m_uiCBP_4Y_TableD[2][15];
  UInt                      m_uiCBP_4Y_VlcIdx;
#else
  UInt                      m_uiBlkCBPTableD[2][15];
  UInt                      m_uiCBPTableD[2][8];
  UInt                      m_uiCbpVlcIdx[2];
  UInt                      m_uiBlkCbpVlcIdx;
#endif


  
  Int                   m_iRefFrame0[1000];
  Int                   m_iRefFrame1[1000];
  Bool                  m_bMVres0[1000];
  Bool                  m_bMVres1[1000];
#if MS_LCEC_LOOKUP_TABLE_EXCEPTION
  UInt                  m_uiMI1TableD[9];
#else
  UInt                  m_uiMI1TableD[8];
#endif
  UInt                  m_uiMI2TableD[15]; 
  UInt                  m_uiMITableVlcIdx;

#if CAVLC_COUNTER_ADAPT
#if CAVLC_RQT_CBP
  UChar         m_ucCBP_YUV_TableCounter[4][4];
  UChar         m_ucCBP_4Y_TableCounter[2][2];
  UChar         m_ucCBP_YS_TableCounter[2][3];
  UChar         m_ucCBP_YCS_TableCounter[2][4];
  UChar         m_ucCBP_YUV_TableCounterSum[4];
  UChar         m_ucCBP_4Y_TableCounterSum[2];
  UChar         m_ucCBP_YS_TableCounterSum[2];
  UChar         m_ucCBP_YCS_TableCounterSum[2];
#else
  UChar         m_ucCBFTableCounter    [2][4];
  UChar         m_ucBlkCBPTableCounter [2][2];
  UChar         m_ucCBFTableCounterSum[2];
  UChar         m_ucBlkCBPTableCounterSum[2];
#endif

  UChar         m_ucMI1TableCounter[4];
  UChar         m_ucSplitTableCounter[4][4];
  UChar         m_ucSplitTableCounterSum[4];
  UChar         m_ucMI1TableCounterSum;
#endif

  Int**    m_aaiTempScale;
  Int**    m_aaiTempOffset;
  Int**    m_aaiTempPdmScaleNomDelta;
  Int**    m_aaiTempPdmOffset;
  
public:
  Void  resetEntropy        ( TComSlice* pcSlice  );
  Void  setBitstream        ( TComBitstream* p    )      { m_pcBitstream = p; }
  Void  setAlfCtrl          ( Bool bAlfCtrl )            { m_bAlfCtrl = bAlfCtrl; }
  Void  setMaxAlfCtrlDepth  ( UInt uiMaxAlfCtrlDepth )  { m_uiMaxAlfCtrlDepth = uiMaxAlfCtrlDepth; }
  
  Void  parseTransformSubdivFlag( UInt& ruiSubdivFlag, UInt uiLog2TransformBlockSize );
  Void  parseQtCbf          ( TComDataCU* pcCU, UInt uiAbsPartIdx, TextType eType, UInt uiTrDepth, UInt uiDepth );
  Void  parseQtRootCbf      ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth, UInt& uiQtRootCbf );
  Void  parseAlfFlag        ( UInt& ruiVal );
  Void  parseAlfUvlc        ( UInt& ruiVal );
  Void  parseAlfSvlc        ( Int&  riVal  );
#if MTK_SAO
  Void  parseAoFlag        ( UInt& ruiVal );
  Void  parseAoUvlc        ( UInt& ruiVal );
  Void  parseAoSvlc        ( Int&  riVal  );
#endif
  
  Void  parseNalUnitHeader  ( NalUnitType& eNalUnitType, UInt& TemporalId, Bool& bOutputFlag );
  
  Void  parseSPS            ( TComSPS* pcSPS );
  Void  parsePPS            ( TComPPS* pcPPS);
  void parseSEI(SEImessages&);
  Void  parseSliceHeader    ( TComSlice*& rpcSlice );
  Void  parseTerminatingBit ( UInt& ruiBit );
  
  Void  parseMVPIdx         ( TComDataCU* pcCU, Int& riMVPIdx, Int iMVPNum, UInt uiAbsPartIdx, UInt uiDepth, RefPicList eRefList );
  
  Void  parseSkipFlag       ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
  Void parseMergeFlag       ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth, UInt uiPUIdx );
  Void parseMergeIndex      ( TComDataCU* pcCU, UInt& ruiMergeIndex, UInt uiAbsPartIdx, UInt uiDepth );
  Void parseMergeIndexMV    ( TComDataCU* pcCU, UInt& ruiMergeIndex, UInt uiAbsPartIdx, UInt uiDepth );
  Void parseResPredFlag     ( TComDataCU* pcCU, Bool& rbResPredFlag, UInt uiAbsPartIdx, UInt uiDepth );
  Void parseSplitFlag       ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
#if MW_MVI_SIGNALLING_MODE == 0
  Void parseMvInheritanceFlag( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
#endif
  Void parsePartSize        ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
  Void parsePredMode        ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
  
  Void parseIntraDirLumaAng ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
  
  Void parseIntraDirChroma  ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
  
  Void parseInterDir        ( TComDataCU* pcCU, UInt& ruiInterDir, UInt uiAbsPartIdx, UInt uiDepth );
  Void parseRefFrmIdx       ( TComDataCU* pcCU, Int& riRefFrmIdx,  UInt uiAbsPartIdx, UInt uiDepth, RefPicList eRefList );
  Void parseMvd             ( TComDataCU* pcCU, UInt uiAbsPartAddr,UInt uiPartIdx,    UInt uiDepth, RefPicList eRefList );
  
  Void parseDeltaQP         ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
#if CAVLC_RQT_CBP
  Void parseCbfTrdiv        ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiTrDepth, UInt uiDepth, UInt& uiSubdiv );
  UInt xGetFlagPattern      ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth,  UInt& uiSubdiv );
#endif
  Void parseCbf             ( TComDataCU* pcCU, UInt uiAbsPartIdx, TextType eType, UInt uiTrDepth, UInt uiDepth );
  Void parseBlockCbf        ( TComDataCU* pcCU, UInt uiAbsPartIdx, TextType eType, UInt uiTrDepth, UInt uiDepth, UInt uiQPartNum );
  Void parseCoeffNxN        ( TComDataCU* pcCU, TCoeff* pcCoef, UInt uiAbsPartIdx, UInt uiWidth, UInt uiHeight, UInt uiDepth, TextType eTType );
  
  Void parseAlfCtrlDepth    ( UInt& ruiAlfCtrlDepth );
  Void parseAlfCtrlFlag     ( TComDataCU* pcCU, UInt uiAbsPartIdx, UInt uiDepth );
#if TSB_ALF_HEADER
  Void parseAlfFlagNum      ( UInt& ruiVal, UInt minValue, UInt depth );
  Void parseAlfCtrlFlag     ( UInt &ruiAlfCtrlFlag );
#endif

#ifdef WEIGHT_PRED
  Void parseWeightPredTable ( TComSlice* pcSlice );
#endif

  Void parseViewIdx         (Int& riViewIdx) ;
};
#endif // !defined(AFX_TDECCAVLC_H__9732DD64_59B0_4A41_B29E_1A5B18821EAD__INCLUDED_)

